local icos = {'', ''}
local testr = {'boyfriend', 'dad'}

local rayman = {x = 150,  y = 0} -- icons origins I suppose
local origins = {x = 150,  y = 0}

local bopEvery = 1
local hpBounce = false

function onCreatePost()
    icos[1] = getProperty('boyfriend.healthIcon')
    icos[2] = getProperty('dad.healthIcon')

    screenCenter('healthBar', 'x')
    screenCenter('healthBarBG', 'x')

    setObjectOrder('healthBar', getObjectOrder('strumLineNotes') - 1)
    setObjectOrder('healthBarBG', getObjectOrder('strumLineNotes') - 2)

    setProperty('iconP1.visible', false) -- because iconP1 killed my grandmother, ok?!
    setProperty('iconP2.visible', false)

    for i = 1, #icos do -- assumes that the icon is name "icon-char" none of that "bf-icon" or "bf" shit
        makeLuaSprite('iconP'..i..'F', 'icons/icon-' .. icos[i], getProperty('healthBar.x'), getProperty('iconP'..i..'.y'))

        setObjectCamera('iconP'..i..'F', 'hud')

        if stringEndsWith(icos[i], '-pixel') then setProperty('iconP'..i..'F.antialiasing', false) end
        setObjectOrder('iconP'..i..'F', getObjectOrder('healthBar') + i)

        if i == 1 then setProperty('iconP'..i..'F.flipX', true) end

        addLuaSprite('iconP'..i..'F')

        setProperty('iconP'..i..'F.alpha', getProperty('healthBar.alpha'))
        setProperty('iconP'..i..'F.visible', getProperty('healthBar.visible'))
    end
end

function onUpdate(elapsed)
    for i = 1, #icos do    
        setProperty('iconP'..i..'F.scale.x', math.lerp(1, getProperty('iconP'..i..'F.scale.x'), fakeBoundTo(1 - (elapsed * 9), 0, 1)))
        setProperty('iconP'..i..'F.scale.y', math.lerp(1, getProperty('iconP'..i..'F.scale.y'), fakeBoundTo(1 - (elapsed * 9), 0, 1)))
        --doTweenX('iconPFX'..i, 'iconP'..i..'F.scale', 1, 0.2, 'elasticOut') -- fuck
        --doTweenY('iconPFY'..i, 'iconP'..i..'F.scale', 1, 0.2, 'elasticOut')
    end

    if hpBounce then
        setProperty('healthBar.scale.x', math.lerp(1, getProperty('healthBar.scale.x'), fakeBoundTo(1 - (elapsed * 9), 0, 1)))
        setProperty('healthBar.scale.y', math.lerp(1, getProperty('healthBar.scale.y'), fakeBoundTo(1 - (elapsed * 9), 0, 1)))

        setProperty('healthBarBG.scale.x', math.lerp(1, getProperty('healthBarBG.scale.x'), fakeBoundTo(1 - (elapsed * 9), 0, 1)))
        setProperty('healthBarBG.scale.y', math.lerp(1, getProperty('healthBarBG.scale.y'), fakeBoundTo(1 - (elapsed * 9), 0, 1)))
    end

    doTweenX('weee1', 'iconP1F', getProperty('iconP1.x') - (getProperty('iconP1F.width') / 2), 0.1, 'linear')
    doTweenX('weee2', 'iconP2F', getProperty('iconP2.x'), 0.1, 'linear')

    if curStep <= 1 then
        setProperty('iconP1F.x', getProperty('iconP1.x') - 150)
        setProperty('iconP2F.x', getProperty('iconP2.x'))
    end

    setProperty('iconP1F.y', getProperty('iconP1.y'))
    setProperty('iconP2F.y', getProperty('iconP2.y'))

    if getProperty('healthBar.percent') > 80 then
        adjustIcon('iconP2F', false) else
        adjustIcon('iconP2F', true) end
    
    if getProperty('healthBar.percent') < 20 then
        adjustIcon('iconP1F', false)
        adjustIcon('iconP3F', false)
    else
        adjustIcon('iconP1F', true)
        adjustIcon('iconP3F', true)
    end
end

function onBeatHit()
    scaleObject('iconP1', 1, 1) -- the scaling messes with the icon's x
    scaleObject('iconP2', 1, 1)

    if hpBounce and curBeat % bopEvery == 0 then
        setProperty('healthBar.scale.x', 1.1)
        setProperty('healthBar.scale.y', 1.1)

        setProperty('healthBarBG.scale.x', 1.1)
        setProperty('healthBarBG.scale.y', 1.1)
    end

    if curBeat % bopEvery == 0 then
        setProperty('iconP1F.origin.x', rayman.x)
        setProperty('iconP1F.origin.y', rayman.y)
        setProperty('iconP1F.scale.x', 1.2)
        setProperty('iconP1F.scale.y', 1.2)
  
        setProperty('iconP2F.origin.x', origins.x)
        setProperty('iconP2F.origin.y', origins.y)
        setProperty('iconP2F.scale.x', 1.2)
        setProperty('iconP2F.scale.y', 1.2)
    end
end

function onStepHit() -- only checks every step if there is a new character icon
    check = {getProperty('boyfriend.healthIcon'), getProperty('dad.healthIcon')}
    for i = 1, #icos do
        if check[i] ~= icos[i] then
            if check[i] == testr[i]..'.healthIcon' then table.remove(icos, i) return 
            else icos[i] = check[i] end

            makeLuaSprite('iconP'..i..'F', 'icons/icon-' .. icos[i], getProperty('iconP'..i..'.x'), getProperty('iconP'..i..'.y'))
            setObjectCamera('iconP'..i..'F', 'hud')

            setObjectOrder('iconP'..i..'F', getObjectOrder('healthBar') + i)
            if i == 1 then setProperty('iconP'..i..'F.flipX', true) end

            if stringEndsWith(icos[i], '-pixel') then setProperty('iconP'..i..'F.antialiasing', false) end

            setObjectOrder('iconP'..i..'F', getObjectOrder('healthBar') + i)

            addLuaSprite('iconP'..i..'F')
        end
    end
end

function adjustIcon(icon, based)
    if not based then -- stole this from ralt
        setProperty(icon .. "._frame.frame.x", getProperty(icon..'.width') / 2)
        setProperty(icon .. "._frame.frame.y", 0)
        setProperty(icon .. "._frame.frame.width", getProperty(icon..'.width'))
        setProperty(icon .. "._frame.frame.height", getProperty(icon..'.height'))
    elseif based then
        setProperty(icon .. "._frame.frame.x", 0)
        setProperty(icon .. "._frame.frame.y", 0)
        setProperty(icon .. "._frame.frame.width", getProperty(icon..'.width') / 2)
        setProperty(icon .. "._frame.frame.height", getProperty(icon..'.height'))
    end
end

function math.lerp(a, b, t)
    return (b - a) * t + a;
end

function fakeBoundTo(v, min, max)
    return math.max(min, math.min(max, v))
end